/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.gc;

public interface Finalizer {
    /**
     * Implement this method to perform finalization on an object registered
     * with {@link FinalizationGroup#registerFinalizer(Object referrent, Finalizer finalizer)}.

     * @param forced <code>true</code> if the finalizer was invoked upon user
     *        request; <code>false</code> if it was invoked upon object garbage
     *        collection.
     * @return FinalizationStatus null if the finalization is finished when
     *         this method returns; otherwise, a future that allows to
     *         query for the status of asynchronous finalization.
     */
    FinalizationStatus finalizeObject(boolean forced);
}
